﻿//#define USE_QUERY_EXPRESSION

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LINQtoSQLExample
{
    public partial class LINQtoSQLExampleForm : Form
    {
        public LINQtoSQLExampleForm()
        {
            InitializeComponent();

            //Standard LINQ
            //string[] words = { "one", "two", "three", "four", "five" };
            //var r = from word in words
            //        where word.Length > 4
            //        select word;
            //foreach (string s in r)
            //    MessageBox.Show(s);







            string connectionString = "Data Source=BRIAN-C5B9B13CD;Initial Catalog=AdventureWorks;Integrated Security=True";
            AdventureWorks.AdventureWorks adventureWorks = new AdventureWorks.AdventureWorks(connectionString);

            /* SQL
            select Color, AVG(ListPrice) as 'AvgListPrice', COUNT(*) as 'Count'
            from Production.Product
            where ProductNumber like 'FR-%'
            group by Color
            order by Color desc
            */

            //LINQ to SQL
#if USE_QUERY_EXPRESSION
            // LINQ: query expression
            dataGridView1.DataSource = from product in adventureWorks.Production_Products
                                       where product.ProductNumber.StartsWith("FR-")
                                       group product by product.Color into productGroup
                                       orderby productGroup.Key descending
                                       select new
                                       {
                                           Colour = productGroup.Key,
                                           AvgListPrice = productGroup.Average(p => p.ListPrice),
                                           Count = productGroup.Count()
                                       };


#else
            // LINQ: method-based
            dataGridView1.DataSource = adventureWorks.Production_Products
                .Where(product => product.ProductNumber.StartsWith("FR-"))
                .GroupBy(product => product.Color)
                .OrderByDescending(product => product.Key)
                .Select(
                    productGroup => new {
                        Colour = productGroup.Key, 
                        AvgDaysToManufacture = productGroup.Average(p => p.DaysToManufacture),
                        Count = productGroup.Count()});                

#endif
            return;

            #region Other query
            /* - In SQL
            select ProductId, AVG(DaysToManufacture) as 'AvgDaysToManufacture'
            from Production.Product
            group by ProductID 
            */

#if USE_QUERY_EXPRESSION
            // LINQ: query expression
            dataGridView1.DataSource = from product in adventureWorks.Production_Products
                                       group product by product.ProductID into productGroup
                                       select new {productGroup.Key, 
                                                   AvgDaysToManufacture = productGroup.Average(p => p.DaysToManufacture)};

#else
            // LINQ: method-based
            dataGridView1.DataSource = adventureWorks.Production_Products
                .GroupBy(product => product.ProductID)
                .Select(
                    productGroup => new {
                        productGroup.Key, 
                        AvgDaysToManufacture = productGroup.Average(p => p.DaysToManufacture)});

#endif
            #endregion
        }
    }
}
